# WiseMindAI 网页剪藏浏览器扩展

一款强大的浏览器扩展，帮助您快速将网页内容保存到 WiseMindAI 知识管理平台。支持保存链接、笔记和知识卡片，让您的知识收集更加高效便捷。

## ✨ 主要功能

### 📌 保存网页链接

- 点击扩展图标，一键保存当前页面为链接
- 自动获取页面标题、URL、图标和纯文本内容
- 支持自定义标题和链接信息

### 📝 保存笔记

- 选中网页文本，右键选择"保存 WiseMindAI 笔记"
- 支持自定义笔记标题格式（支持变量：`{title}`、`{date}`、`{time}`）
- 自动添加来源信息（可自定义后缀内容模板）
- 支持换行格式的来源信息

### 🎴 保存知识卡片

- 选中网页文本，右键选择"保存为知识卡片"
- 选择卡片集和卡片目录
- 支持快速创建新的卡片集和卡片目录
- 支持保存常用配置，方便重复使用
- 自动应用默认卡片集、目录和背景色配置

### ⚙️ 丰富的配置选项

- **API 配置**：设置 WiseMindAI 本地 API 服务端点，支持连接测试
- **文档配置**：启用/禁用浮窗按钮
- **笔记配置**：自定义笔记标题格式和后缀内容模板
- **知识卡片配置**：设置默认卡片集、目录和背景色

### 🎯 智能功能

- **浮窗按钮**：在网页右下角显示快速保存按钮（可配置）
- **系统页面检测**：自动在系统页面（如 `chrome://extensions/`）禁用功能
- **保存配置**：知识卡片支持保存常用配置组合
- **成功/失败提示**：所有保存操作都有清晰的通知提示

## 🚀 快速开始

### 安装要求

- Chrome 浏览器或基于 Chromium 的浏览器（如 Edge、Brave 等）
- WiseMindAI 客户端已安装并运行
- 在 WiseMindAI 中启用本地 API 服务

### 安装步骤

1. **下载扩展**

   - 从 [WiseMindAI 官网](https://wisemindai.app/) 下载扩展包
   - 或从 Chrome 网上应用店安装

2. **配置 API 端点**

   - 点击扩展图标，选择"设置"
   - 在"API 配置"中输入 WiseMindAI 的本地 API 服务端口（默认：`127.0.0.1:38221`）
   - 点击"测试连接"验证配置是否正确
   - 点击"保存设置"

3. **开始使用**
   - 点击扩展图标保存当前页面为链接
   - 选中文本后右键选择"保存 WiseMindAI 笔记"或"保存为知识卡片"

## 📖 使用指南

### 保存网页链接

1. 打开要保存的网页
2. 点击浏览器工具栏中的 WiseMindAI 扩展图标
3. 在弹出的窗口中确认标题和链接信息
4. 点击"保存"按钮

**注意**：保存的链接会自动包含页面的纯文本内容，方便后续搜索和查看。

### 保存笔记

1. 在网页中选中要保存的文本
2. 右键点击选中的文本
3. 选择"保存 WiseMindAI 笔记"
4. 笔记会自动保存，并显示成功或失败通知

**自定义配置**：

- 在设置中可以配置笔记标题格式，例如：`{title} - {date}`
- 可以自定义后缀内容模板，例如：
  ```
  来源：《{title}》
  原文链接：{url}
  ```

### 保存知识卡片

1. 在网页中选中要保存的文本
2. 右键点击选中的文本
3. 选择"保存为知识卡片"
4. 在弹出的对话框中选择卡片集和卡片目录
5. 可以编辑内容，然后点击"保存"

**快捷功能**：

- 点击"+"按钮可以快速创建新的卡片集或卡片目录
- 可以保存当前选择的卡片集和目录组合为配置，方便下次使用
- 支持从下拉框快速选择已保存的配置

### 浮窗按钮

1. 在设置中启用"浮窗按钮"
2. 在网页右下角会显示一个浮窗按钮
3. 点击浮窗按钮可以快速打开保存链接的弹窗

## ⚙️ 设置说明

### API 配置

- **API 端点**：输入 WiseMindAI 本地 API 服务的地址和端口
  - 格式：`127.0.0.1:38221` 或 `http://127.0.0.1:38221`
  - 端口号需要与 WiseMindAI 设置中的"本地 API 服务端口"保持一致
- **测试连接**：点击按钮可以测试 API 连接是否正常

### 文档配置

- **启用浮窗按钮**：在网页右下角显示快速保存按钮

### 笔记配置

- **默认笔记标题格式**：支持变量
  - `{title}`：页面标题
  - `{date}`：当前日期
  - `{time}`：当前时间
- **显示后缀内容**：是否在笔记末尾添加来源信息
- **后缀内容模板**：自定义后缀内容格式（支持换行）
  - `{title}`：页面标题
  - `{url}`：页面链接

### 知识卡片配置

- **默认卡片集**：保存知识卡片时默认使用的卡片集
- **默认卡片目录**：保存知识卡片时默认使用的卡片目录
- **卡片背景色**：选择保存知识卡片时的默认背景色（8 种颜色可选）

## 🔧 技术特性

### 系统页面检测

扩展会自动检测系统页面（如 `chrome://extensions/`、`edge://extensions/` 等），在这些页面中：

- 扩展图标会显示红色 "×" 标记
- 右键菜单会被禁用
- 浮窗按钮不会显示
- Popup 中的保存按钮会被禁用

### 数据存储

- 所有配置信息存储在浏览器的同步存储中
- 支持跨设备同步（如果浏览器启用了同步功能）
- 知识卡片的保存配置也会同步保存

### 错误处理

- 所有保存操作都有完整的错误处理
- 连接失败时会显示详细的错误信息
- 提供友好的错误提示和解决建议

## 📝 注意事项

1. **API 服务要求**

   - WiseMindAI 客户端必须正在运行
   - 必须在 WiseMindAI 设置中启用"本地 API 服务"
   - 端口号必须与扩展配置一致

2. **系统页面限制**

   - 在系统页面（`chrome://`、`edge://` 等）无法使用扩展功能
   - 这是浏览器的安全限制，无法绕过

3. **内容格式**
   - 笔记保存为纯文本格式
   - 知识卡片保存为纯文本内容
   - 链接保存时包含页面的纯文本内容

## 🔗 相关链接

- [WiseMindAI 官网](https://wisemindai.app/)
- [下载客户端](https://wisemindai.app/download/)
- [购买 VIP](https://wisemindai.app/pricing/)
- [使用教程](https://wisemindai.app/)

## 📄 许可证

Copyright © 2024-2025 WiseMindAI

## 🐛 问题反馈

如果遇到问题或有功能建议，请通过以下方式反馈：

- 访问 [WiseMindAI 官网](https://wisemindai.app/) 提交反馈
- 在扩展设置页面点击"打开官网"查看帮助文档
